/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr.appletssl;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AppletInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 8192;
    protected DataInputStream in;
    protected byte[] buffer = new byte[8192];
    protected int bytesRemaining = 0;
    protected int currOffset = 0;

    public AppletInputStream(InputStream in) {
        this.in = new DataInputStream(in);
    }

    private void readRecord() throws IOException {
        this.debugPrint("-> AppletInputStream.readRecord()");
        byte type = this.in.readByte();
        short len = this.in.readShort();
        if (type == 1) {
            this.in.readFully(this.buffer, 0, len);
            this.bytesRemaining = len;
            this.currOffset = 0;
        } else {
            byte[] data = null;
            if (len > 0) {
                data = new byte[len];
                this.in.readFully(data);
            }
            this.handleEventData(type, data);
        }
        this.debugPrint("<- AppletInputStream.readRecord()");
    }

    public int read() throws IOException {
        this.debugPrint("-> AppletInputStream.read()");
        while (this.bytesRemaining == 0) {
            this.readRecord();
        }
        int data = this.buffer[this.currOffset] & 0xFF;
        --this.bytesRemaining;
        ++this.currOffset;
        this.debugPrint("<- AppletInputStream.read()");
        return data;
    }

    public int read(byte[] b) throws IOException {
        this.debugPrint("<> AppletInputStream.read(byte[])");
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.debugPrint("-> AppletInputStream.read(byte[],int,int)");
        while (this.bytesRemaining == 0) {
            this.readRecord();
        }
        int readLen = len > this.bytesRemaining ? this.bytesRemaining : len;
        System.arraycopy(this.buffer, this.currOffset, b, off, readLen);
        this.bytesRemaining -= readLen;
        this.currOffset += readLen;
        this.debugPrint("<- AppletInputStream.read(byte[],int,int)");
        return readLen;
    }

    public int available() {
        this.debugPrint("<> AppletInputStream.available()");
        return this.bytesRemaining;
    }

    public void close() throws IOException {
        this.debugPrint("<> AppletInputStream.close()");
        this.in.close();
    }

    public abstract void handleEventData(byte var1, byte[] var2);

    private void debugPrint(Object o) {
    }
}

